//
//  AFNetworkDocument.h
//  CoreNetworking
//
//  Created by Keith Duncan on 17/10/2010.
//  Copyright 2010. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *const AFNetworkDocumentMIMEContentType;
extern NSString *const AFNetworkDocumentMIMEContentTransferEncoding;
extern NSString *const AFNetworkDocumentMIMEContentDisposition;

@interface AFNetworkDocument : NSObject

/*!
	\brief
	Used to convert the document into a wire format. This efficiently decomposes the document into multiple packets.
	
	\param contentTypeRef
	The MIME type of the serialised document. Must not be NULL.
	
	\param frameLengthRef
	The combined frame length of the packets. Must not be NULL.
	
	\return
	An ordered collection of <tt>AFPacket <AFNetworkPacketWriting></tt> objects which should be replayed over a write stream, nil if the document couldn't be serialised.
 */
- (NSArray *)serialisedPacketsWithContentType:(NSString **)contentTypeRef frameLength:(NSUInteger *)frameLengthRef;

/*!
	\brief
	Used to convert the document into a wire format. This inefficiently decomposes the document into a single data object.
	
	\details
	The default implementation is suitable for inheriting, it uses <tt>serialisedPacketsWithContentType:frameLength:</tt> to generate the packets, then accumulates them in an in-memory stream returning the result.
 
	\param contentTypeRef
	The MIME type of the serialised document. Must not be NULL.
	
	\return
	The serialised document, nil if the document couldn't be serialised.
 */
- (NSData *)serialisedDataWithContentType:(NSString **)contentTypeRef;

@end
